---
title: Deploy a WAF managed ruleset in the dashboard · Cloudflare Web
  Application Firewall (WAF) docs
description: The instructions on this page will guide you through deploying and
  configuring a managed ruleset for a zone.
lastUpdated: 2025-11-13T11:49:22.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/managed-rules/deploy-zone-dashboard/
  md: https://developers.cloudflare.com/waf/managed-rules/deploy-zone-dashboard/index.md
---

The instructions on this page will guide you through deploying and configuring a managed ruleset for a zone.

To deploy a managed ruleset for several Enterprise domains in your account, refer to [Deploy a managed ruleset in the dashboard for an account](https://developers.cloudflare.com/waf/account/managed-rulesets/deploy-dashboard/).

## Deploy a managed ruleset

To deploy a managed ruleset with the default configuration:

* Old dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/), and select your account and domain.

  2. Go to **Security** > **WAF** > **Managed rules** tab.

  3. Under **Managed Rulesets**, select **Deploy** next to a managed ruleset.

     ![Example WAF Managed Rules configuration in the Managed rules tab under Security > WAF. There are two managed rulesets already deployed, and one managed ruleset available for deployment.](https://developers.cloudflare.com/_astro/waf-managed-rules-tab.CJ_mD1P3_Z5LcAf.webp)

  This operation deploys the managed ruleset for the current zone, creating a new rule with the *Execute* action.

* New dashboard

  1. In the Cloudflare dashboard, go to the Security **Settings** page.

     [Go to **Settings**](https://dash.cloudflare.com/?to=/:account/:zone/security/settings)

  2. (Optional) Filter by **Web application exploits**.

  3. Turn on the managed ruleset(s) you want to deploy:

     * **Cloudflare managed ruleset** - Deploys the [Cloudflare Managed Ruleset](https://developers.cloudflare.com/waf/managed-rules/reference/cloudflare-managed-ruleset/).
     * **OWASP Core** - Deploys the [Cloudflare OWASP Core Ruleset](https://developers.cloudflare.com/waf/managed-rules/reference/owasp-core-ruleset/).
     * **Sensitive data detection** - Deploys the [Cloudflare Sensitive Data Detection](https://developers.cloudflare.com/waf/managed-rules/reference/sensitive-data-detection/) managed ruleset.

To temporarily turn off a managed ruleset without deleting its deployment configuration, use the toggle next to the rule that deploys the managed ruleset.

## Configure a managed ruleset

Configure a managed ruleset to:

* Specify a custom filter expression to apply the rules in the ruleset to a subset of incoming requests.
* Define specific field values for one or more rules (for example, configure a rule with an action different from the action configured by Cloudflare), or turn off those rules.

To skip one or more rules — or even entire managed rulesets — for specific incoming requests, [add an exception](https://developers.cloudflare.com/waf/managed-rules/waf-exceptions/).

Note

Some managed rulesets may not allow custom configuration, depending on your Cloudflare plan.

### Configure field values for all the rules

To configure rule field values for all the rules in a managed ruleset:

* Old dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/), and select your account and domain.

  2. Go to **Security** > **WAF** > **Managed rules** tab.

  3. Next to the *Execute* rule deploying the managed ruleset you want to configure, select the managed ruleset name.\
     If you have not deployed the managed ruleset yet, select the managed ruleset name under **Managed Rulesets**.

  4. (Optional) To execute the managed ruleset for a subset of incoming requests, select **Edit scope** and [configure the expression](https://developers.cloudflare.com/ruleset-engine/rules-language/expressions/edit-expressions/) that will determine the scope of the current rule deploying the managed ruleset.

  5. In the ruleset configuration section, define settings for all the rules in the ruleset by setting one or more fields using the drop-down lists.

     For example, select the action to perform for all the rules in the ruleset from the **Ruleset action** drop-down list.

     ![The Configure Managed Ruleset page displaying the available options to override all the rules in the ruleset. In the displayed managed ruleset you can override the ruleset action.](https://developers.cloudflare.com/_astro/waf-configure-ruleset.CVZg7RyP_21SgNq.webp)

  6. If you are editing a deployed managed ruleset, select **Save**. If you have not deployed the managed ruleset yet, select **Deploy** to deploy the ruleset immediately, or **Save as Draft** to save your deployment settings for later.

* New dashboard

  1. In the Cloudflare dashboard, go to the **Security rules** page.

     [Go to **Security rules**](https://dash.cloudflare.com/?to=/:account/:zone/security/security-rules)

  2. (Optional) Filter by **Managed rules**.

  3. Search for the managed ruleset you want to configure. Look for a rule with an *Execute* action.

  4. Select the rule name (containing the name of the managed ruleset).

  5. (Optional) To execute the managed ruleset for a subset of incoming requests, select **Edit scope** and [configure the expression](https://developers.cloudflare.com/ruleset-engine/rules-language/expressions/edit-expressions/) that will determine the scope of the current rule deploying the managed ruleset.

  6. In the ruleset configuration section, define settings for all the rules in the ruleset by setting one or more fields using the drop-down lists.

     For example, select the action to perform for all the rules in the ruleset from the **Ruleset action** drop-down list.

     ![The Configure Managed Ruleset page displaying the available options to override all the rules in the ruleset. In the displayed managed ruleset you can override the ruleset action.](https://developers.cloudflare.com/_astro/waf-configure-ruleset.CVZg7RyP_21SgNq.webp)

  7. Select **Save**.

### Configure rules in bulk in a managed ruleset

* Old dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/), and select your account and domain.

  2. Go to **Security** > **WAF** > **Managed rules** tab.

  3. If you have already deployed the managed ruleset you want to configure, select the managed ruleset name in the list of deployed managed rulesets. Alternatively, select the three dots > **Edit** next to the *Execute* rule deploying the managed ruleset.

     If you have not deployed the managed ruleset, select the ruleset name under **Managed Rulesets**.

  4. Select **Browse rules**.

     ![The Cloudflare dashboard displaying the list of rules in the Cloudflare Managed Ruleset](https://developers.cloudflare.com/_astro/waf-browse-rules.lrvrhCdB_Z20FUV8.webp)

  1) Search for rules using the available filters. You can search for tags.

  2) In the results list, select the checkboxes for all the rules you want to configure.

     Alternatively, select a tag name under the search input to filter the rules with that tag, and then select the checkboxes for the rules you want to configure. To extend your selection to all rules with the tag across all pages, select **Select all \<NUMBER> rules**.

     ![Selecting all rules in a page displays additional drop-down lists above the table to override the behavior of several rules at once.](https://developers.cloudflare.com/_astro/waf-modify-selected-rules.DrTbw8v1_Z2aSCWH.webp)

  3) Update one or more fields for the selected rules using the buttons displayed in the top right corner of the table.

  4) Select **Next**.

  5) If you selected a tag, a dialog appears asking you if any new rules with the selected tag should be configured with the field values you selected.

     * Select **Do not apply to new rules** to apply your configurations to the selected rules only.
     * Select **Apply to new rules** if you want to apply your configurations to any new rules with the select tag.

  6) Select **Save**.

* New dashboard

  1. In the Cloudflare dashboard, go to the **Security rules** page.

     [Go to **Security rules**](https://dash.cloudflare.com/?to=/:account/:zone/security/security-rules)

  2. (Optional) Filter by **Managed rules**.

  3. Search for the managed ruleset you want to configure/browse. Look for a rule with an *Execute* action.

  4. Select the rule name (containing the name of the managed ruleset), and then select **Browse rules**.

     ![The Cloudflare dashboard displaying the list of rules in the Cloudflare Managed Ruleset](https://developers.cloudflare.com/_astro/waf-browse-rules.lrvrhCdB_Z20FUV8.webp)

  1) Search for rules using the available filters. You can search for tags.

  2) In the results list, select the checkboxes for all the rules you want to configure.

     Alternatively, select a tag name under the search input to filter the rules with that tag, and then select the checkboxes for the rules you want to configure. To extend your selection to all rules with the tag across all pages, select **Select all \<NUMBER> rules**.

     ![Selecting all rules in a page displays additional drop-down lists above the table to override the behavior of several rules at once.](https://developers.cloudflare.com/_astro/waf-modify-selected-rules.DrTbw8v1_Z2aSCWH.webp)

  3) Update one or more fields for the selected rules using the buttons displayed in the top right corner of the table.

  4) Select **Next**.

  5) If you selected a tag, a dialog appears asking you if any new rules with the selected tag should be configured with the field values you selected.

     * Select **Do not apply to new rules** to apply your configurations to the selected rules only.
     * Select **Apply to new rules** if you want to apply your configurations to any new rules with the select tag.

  6) Select **Save**.

### Configure a single rule in a managed ruleset

* Old dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/), and select your account and domain.

  2. Go to **Security** > **WAF** > **Managed rules** tab.

  3. If you have already deployed the managed ruleset you want to configure, select the managed ruleset name in the list of deployed managed rulesets. Alternatively, select the three dots > **Edit** next to the *Execute* rule deploying the managed ruleset.

     If you have not deployed the managed ruleset, select the ruleset name under **Managed Rulesets**.

  4. Select **Browse rules**.

     ![The Cloudflare dashboard displaying the list of rules in the Cloudflare Managed Ruleset](https://developers.cloudflare.com/_astro/waf-browse-rules.lrvrhCdB_Z20FUV8.webp)

  1) Search for a rule using the available filters. You can search for tags.

  2) Find the rule you want to configure in the results list.

  3) In the result line for the rule you want to change, select the desired value for a field in the displayed drop-down lists. For example, select the rule action in the **Action** dropdown. You can also change the status of a rule using the **Status** toggle next to the rule.

  4) Select **Next**, and then select **Save**.

* New dashboard

  1. In the Cloudflare dashboard, go to the **Security rules** page.

     [Go to **Security rules**](https://dash.cloudflare.com/?to=/:account/:zone/security/security-rules)

  2. (Optional) Filter by **Managed rules**.

  3. Search for the managed ruleset you want to configure/browse. Look for a rule with an *Execute* action.

  4. Select the rule name (containing the name of the managed ruleset), and then select **Browse rules**.

     ![The Cloudflare dashboard displaying the list of rules in the Cloudflare Managed Ruleset](https://developers.cloudflare.com/_astro/waf-browse-rules.lrvrhCdB_Z20FUV8.webp)

  1) Search for a rule using the available filters. You can search for tags.

  2) Find the rule you want to configure in the results list.

  3) In the result line for the rule you want to change, select the desired value for a field in the displayed drop-down lists. For example, select the rule action in the **Action** dropdown. You can also change the status of a rule using the **Status** toggle next to the rule.

  4) Select **Next**, and then select **Save**.

### Browse the rules of a managed ruleset

You can browse the available rules in a managed ruleset and search for individual rules or tags.

* Old dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/), and select your account and domain.

  2. Go to **Security** > **WAF** > **Managed rules** tab.

  3. If you have already deployed the managed ruleset you want to configure, select the managed ruleset name in the list of deployed managed rulesets. Alternatively, select the three dots > **Edit** next to the *Execute* rule deploying the managed ruleset.

     If you have not deployed the managed ruleset, select the ruleset name under **Managed Rulesets**.

  4. Select **Browse rules**.

     ![The Cloudflare dashboard displaying the list of rules in the Cloudflare Managed Ruleset](https://developers.cloudflare.com/_astro/waf-browse-rules.lrvrhCdB_Z20FUV8.webp)

* New dashboard

  1. In the Cloudflare dashboard, go to the **Security rules** page.

     [Go to **Security rules**](https://dash.cloudflare.com/?to=/:account/:zone/security/security-rules)

  2. (Optional) Filter by **Managed rules**.

  3. Search for the managed ruleset you want to configure/browse. Look for a rule with an *Execute* action.

  4. Select the rule name (containing the name of the managed ruleset), and then select **Browse rules**.

     ![The Cloudflare dashboard displaying the list of rules in the Cloudflare Managed Ruleset](https://developers.cloudflare.com/_astro/waf-browse-rules.lrvrhCdB_Z20FUV8.webp)

### Delete a managed ruleset deployment rule or an exception

* Old dashboard

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/) and select your account and domain.
  2. Go to **Security** > **WAF** > **Managed rules** tab.
  3. Next to the rule or exception (skip rule) you want to delete, select the three dots > **Delete** and confirm the operation.

* New dashboard

  1. In the Cloudflare dashboard, go to the **Security rules** page.

     [Go to **Security rules**](https://dash.cloudflare.com/?to=/:account/:zone/security/security-rules)

  2. (Optional) Filter by **Managed rules**.

  3. Search for the managed ruleset you want to configure.

  4. Next to the managed ruleset deployment rule (execute rule) or exception (skip rule) you want to delete, select the three dots > **Delete** and confirm the operation.
