---
title: FTP · Cloudflare Spectrum docs
description: Enabling Spectrum for FTP is not straightforward due to the
  implementation of the protocol. This guide gives an overview of the
  intricacies of FTP and under which circumstances you can enable Spectrum for
  your FTP service.
lastUpdated: 2025-05-01T15:14:34.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/spectrum/about/ftp/
  md: https://developers.cloudflare.com/spectrum/about/ftp/index.md
---

Enabling Spectrum for FTP is not straightforward due to the implementation of the protocol. This guide gives an overview of the intricacies of FTP and under which circumstances you can enable Spectrum for your FTP service.

Note

This feature requires an Enterprise plan. If you would like to upgrade, contact your account team.

## How FTP Operates

FTP leverages two different sockets, one for issuing commands and the other for actual data transfer. The control socket takes care of users logging in and sending commands, and the data socket is where directory listings and files actually get transferred.

There are two ways in which client and server can establish a data socket: active and passive. In active mode, the server connects *back* to the client on a port that they have specified, which can create issues where clients are behind an NAT. The alternative is passive mode, where the server opens an extra port that the client then connects to. For an overview of active versus passive FTP, refer to [Active FTP vs. Passive FTP, a Definitive Explanation](http://slacksite.com/other/ftp.html).

In passive mode, the FTP server communicates a port that the client should connect to, which is done on the control socket via a PASV command. By default, the FTP server responds with the IP address that it is listening on. This scenario is fine for servers running directly on a public-facing IP but creates issues when a server is behind an NAT, firewall, or Cloudflare Spectrum.

Alternatively, more modern FTP server software supports [FTP extensions](https://tools.ietf.org/html/rfc2428), which introduces the EPSV command that omits the IP address that the client should connect on. Instead, the client connects to the same IP that it connected to for the control pane.

## What Does and Does Not Work

Spectrum is able to protect servers serving FTP traffic in *passive mode only*. Active mode is not supported due to the fact that the origin server sees the Spectrum IP as being the client instead of the actual client IP. When the client issues a PORT command with their own IP, the FTP server rejects because the two addresses do not match.

Passive mode in combination with EPSV works out of the box with no origin-side configuration required. Note that the client must also support EPSV for this to work. Traditional passive mode with PASV is possible with minimal origin-side configuration (see below, Protecting an FTP server with Spectrum)

## Protect an FTP Server with Spectrum

Configuring Spectrum to protect your FTP server requires creating a set of Spectrum applications that point to your origin and some configuration on the FTP server.

### Protect the Control Port

The control plane runs on port 21 by default, and there is nothing special that needs to be to protect this part of the FTP server. In the example below, replace 198.51.100.1 with the IP of the origin server.

![Add an application dialog with IP address and port set to 21](https://developers.cloudflare.com/_astro/ftp-control-plane-app.CCDNXmIO_jpBON.webp)

This configuration proxies incoming connections to the origin. However, if clients issue a PASV command, they will still receive the IP of the actual origin for the data connection. This is not preferred, as this exposes the origin's IP to the client instead of being masked behind Spectrum. Steps to prevent this are documented in sections below.

### Protect Data Ports

Most FTP servers allow configuration of the port range that the server will use to open data connections. It is recommended to specify a port range to prevent accidentally exposing other ports on the server. For each port in the range, create a corresponding Spectrum application that maps to that port.

Additionally, the FTP server needs to be configured to expose the correct IP when the client issues a PASV command. This IP should match the IP of the Spectrum app.

Some FTP servers also allow dynamic resolving of hostnames. In this case, it is recommended to use the Spectrum app URL instead of the IP.

Example configuration for [vsftpd](https://security.appspot.com/vsftpd.html):

> ```bash
> pasv_min_port=20000
> pasv_max_port=20020
>
>
> pasv_enable=YES
> pasv_address=ftp.example.com
> pasv_addr_resolve=YES
> pasv_promiscuous=YES
> ```

### Spectrum FTPS (ProFTPD) instructions

To use Spectrum TCP to proxy and protect FTPS, specifically ProFTPD, the following example configuration is recommended:

* **Control Port**: Port 21
* **Data Ports**: Port ranges 50000-50500

On the ProFTPD server side use the following example configuration:

* `MasqueradeAddress`: `www.example.com`
* `AllowForeignAddress`: You can use the option `on` to allow all IPs, but it is recommended to only allow [Cloudflare IP](https://developers.cloudflare.com/fundamentals/concepts/cloudflare-ip-addresses/#allow-cloudflare-ip-addresses).
* `PassivePorts`: `50000-50500`

For more details, refer to the [ProFTPD documentation](http://www.proftpd.org/docs/modules/mod_core.html).

## SFTP

Unlike FTP or FTPS, enabling Spectrum for SFTP does not require extra configuration. When setting up a Spectrum application for SSH, select port 22 and TCP.

## Microsoft Windows IIS FTP

Refer to the [Microsoft Windows IIS documentation](https://docs.microsoft.com/en-us/iis/publish/using-the-ftp-service/configuring-ftp-firewall-settings-in-iis-7#step-1-configure-the-passive-port-range-for-the-ftp-service) to configure a static data port range and external IP matching your Spectrum application.

Additionally, IIS requires that the source IP for both, FTP control and data connections are the same. However, when using Spectrum, this requirement may not be met, as both connections often terminate on different servers with their own unique egress IPs. To ensure proper functionality, also set `dataChannelSecurity/matchClientAddressForPasv = false`. Refer to [Microsoft Windows IIS FTP Official Guide](https://learn.microsoft.com/en-us/iis/configuration/system.applicationhost/sites/site/ftpserver/security/datachannelsecurity) for further details.
