---
title: Email security · Cloudflare One docs
description: Email security is the practice of protecting your email inbox from
  cyber attacks and unwanted communication sent via email.
lastUpdated: 2025-10-27T15:00:52.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/email-security/
  md: https://developers.cloudflare.com/cloudflare-one/email-security/index.md
---

Important

Refer to [Area 1](https://developers.cloudflare.com/email-security/) if you are looking for the Area 1 documentation.

Note

If you have not yet purchased Email security, you can try Email security with Retro Scan. Refer to [Retro Scan](https://developers.cloudflare.com/cloudflare-one/email-security/retro-scan/) to learn more.

Protect your email inbox with Email security.

Email security is the practice of protecting your email inbox from cyber attacks and unwanted communication sent via email.

Cloudflare's Email security uses Artificial Intelligence (AI), threat intelligence, and expert security rules to analyze every incoming email.

Email security protects your email inbox from phishing attacks, malware, [Business Email Compromise](https://www.cloudflare.com/en-gb/learning/email-security/business-email-compromise-bec/) attacks, and vendor email fraud.

Cloudflare's Email security integrates with your existing email provider (such as Microsoft 365 or Gmail), and reduces the amount of spam and phishing emails landing in your inbox. You can configure Email security via [API](https://developers.cloudflare.com/cloudflare-one/email-security/setup/post-delivery-deployment/api/), [BCC](https://developers.cloudflare.com/cloudflare-one/email-security/setup/post-delivery-deployment/bcc-journaling/bcc-setup/gmail-bcc-setup/gmail-bcc-setup/)/[Journaling](https://developers.cloudflare.com/cloudflare-one/email-security/setup/post-delivery-deployment/bcc-journaling/journaling-setup/m365-journaling/), or [MX/Inline](https://developers.cloudflare.com/cloudflare-one/email-security/setup/pre-delivery-deployment/mx-inline-deployment-setup/) deployment. All three deployments aim at protecting your organization from malicious activities.

When you complete the [setup process](https://developers.cloudflare.com/cloudflare-one/email-security/setup/), the Cloudflare dashboard will display the Email security overview page.

The Email security overview provides you with:

* **Quick actions**, where you can:

  * View [reclassifications](https://developers.cloudflare.com/cloudflare-one/email-security/reclassifications/)
  * Manage detection settings: manage [allow policies](https://developers.cloudflare.com/cloudflare-one/email-security/settings/detection-settings/allow-policies/), [blocked senders](https://developers.cloudflare.com/cloudflare-one/email-security/settings/detection-settings/blocked-senders/), [trusted domains](https://developers.cloudflare.com/cloudflare-one/email-security/settings/detection-settings/trusted-domains/), [impersonation registry](https://developers.cloudflare.com/cloudflare-one/email-security/settings/detection-settings/impersonation-registry/) and [additional detections](https://developers.cloudflare.com/cloudflare-one/email-security/settings/detection-settings/additional-detections/).
  * [Run screens](https://developers.cloudflare.com/cloudflare-one/email-security/investigation/search-email/#screen-criteria)

* **Recommendations**: A series of recommendations. For example, you may be recommended to learn how to submit emails for reclassification, create policies, or protect users at risk of [impersonation](https://developers.cloudflare.com/cloudflare-one/email-security/settings/detection-settings/impersonation-registry/)

* **Email security metrics**: Activity from the last seven days.

* **Recently modified policies** A list of modified policies.

* **Education and resources**: Links to [implementation guides](https://developers.cloudflare.com/cloudflare-one/implementation-guides/), [Email security changelogs](https://developers.cloudflare.com/cloudflare-one/changelog/email-security/), and [API documentation](https://developers.cloudflare.com/api/resources/email_security/subresources/investigate/methods/get/)

To access the Email security overview:

1. Log in to [Cloudflare One](https://one.dash.cloudflare.com/).
2. Go to **Email security** > **Overview**.
